---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-500エラーページ (App Error)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/components/builtin/app-error.tsx` L1-36 - コンポーネント全体
- E-02: `packages/next/src/client/components/builtin/app-error.tsx` L4 - コメント「static 500.html page」
- E-03: `packages/next/src/client/components/builtin/app-error.tsx` L8 - html id属性
- E-04: `packages/next/src/client/components/builtin/app-error.tsx` L10 - titleタグ
- E-05: `packages/next/src/client/components/builtin/app-error.tsx` L17 - h1タイトル
- E-06: `packages/next/src/client/components/builtin/app-error.tsx` L18-20 - メッセージとヒント
- E-07: `packages/next/src/client/components/builtin/app-error.tsx` L24-26 - Reload pageボタン
- E-08: `packages/next/src/client/components/builtin/error-styles.tsx` L3-86 - errorStyles
- E-09: `packages/next/src/client/components/builtin/error-styles.tsx` L88-124 - errorThemeCss
- E-10: `packages/next/src/client/components/builtin/error-styles.tsx` L126-152 - ErrorIcon
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv` L8 - 画面情報定義
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L20-21 - 関連機能情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ビルド時に静的500.htmlとして生成される | E-02, E-11 | ○ |
| C-02 | タイトル「This page failed to load」を表示 | E-05 | ○ |
| C-03 | メッセージ「Something went wrong while loading this page.」 | E-06 | ○ |
| C-04 | ヒント「If this keeps happening, it may be a server issue.」 | E-06 | ○ |
| C-05 | Reload pageボタンがform submitで実装 | E-07 | ○ |
| C-06 | ErrorIconを表示 | E-01, E-10 | ○ |
| C-07 | html要素にid="__next_error__"が設定 | E-03 | ○ |
| C-08 | titleタグに「500: This page failed to load」 | E-04 | ○ |
| C-09 | HandleISRErrorコンポーネントは含まない | E-01 | ○ |
| C-10 | Go backボタンやdigest表示は含まない | E-01 | ○ |
| C-11 | 'use client'ディレクティブなし | E-01 | ○ |
| C-12 | errorStylesとerrorThemeCssをerror-styles.tsxから取得 | E-01, E-08, E-09 | ○ |
| C-13 | プロパティを受け取らない | E-01 | ○ |
| C-14 | エラーハンドリングが主機能、next buildが補助機能 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] No.6（グローバルエラーページ）との違い（HandleISRError無し、Go back無し、digest無し）が正確か確認
- [ ] 静的HTMLとして生成される旨の記述が正確か確認
